using System;
using System.Data;
using System.Xml;
using System.Data.SqlClient;
using Microsoft.SqlServer.Server;


public partial class Triggers
{
    [Microsoft.SqlServer.Server.SqlTrigger (Name="CreateTableTrigger", Target="DATABASE", Event="CREATE_TABLE")]
    public static void CreateTableTrigger()
    {
        // Sprawdzamy, czy obsugujemy zdarzenie CREATE TABLE
        SqlTriggerContext triggerContext = SqlContext.TriggerContext;
        if (triggerContext.TriggerAction != TriggerAction.CreateTable)
        {
            throw new Exception("Trigger tylko do zdarzenia CREATE TABLE");
        }

        
        //Pobieramy nazw tworzonej tabeli, nazw uytkownika i dat
        String tableName = null;
        String userName = null;
        DateTime date = new DateTime();
        

        //Przechwytujemy opis zdarzenia i obsugujemy jak plik XML
        XmlReader eventreader = triggerContext.EventData.CreateReader();

        while (eventreader.Read())
        {
            if (eventreader.Name.Equals("ObjectName"))
                tableName = eventreader.ReadElementContentAsString();

            if (eventreader.Name.Equals("UserName"))
                userName = eventreader.ReadElementContentAsString();

            if (eventreader.Name.Equals("PostTime"))
                date = DateTime.Parse(eventreader.ReadElementContentAsString());
          
        }
        if (tableName == null || userName == null || date == null)
        {
            throw new Exception("Could not find all information.");
        }

        // wykorzystujemy kontekst aktualnego poczenia
        using (SqlConnection conn = new SqlConnection("context connection=true"))
        {
            //otwieramy poczenie z SQL Server
            conn.Open();
            SqlCommand sqlComm = new SqlCommand();
	        SqlPipe sqlP = SqlContext.Pipe;
            String sql = "";

            sqlComm.Connection = conn;

            //budujemy polecenie
            sql = "INSERT INTO CreateTableLog (TableName, UserName, Date)";
            sql += " VALUES ('" + tableName + "', '" + userName + "', '" + date + "')";

            sqlComm.CommandText = sql;
            
            //wykonujemy polecenie sql
            sqlP.Send(sqlComm.CommandText);
            sqlP.ExecuteAndSend(sqlComm);
        }
    }
}
